/*
 * ACPHY RSSI Compute module interface
 *
 * Copyright (C) 2015, Broadcom Corporation
 * All Rights Reserved.
 * 
 * This is UNPUBLISHED PROPRIETARY SOURCE CODE of Broadcom Corporation;
 * the contents of this file may not be disclosed to third parties, copied
 * or duplicated in any form, in whole or in part, without the prior
 * written permission of Broadcom Corporation.
 *
 * $Id$
 */

#ifndef _phy_ac_rssi_h_
#define _phy_ac_rssi_h_

#include <phy_api.h>
#include <phy_ac.h>
#include <phy_rssi.h>

#define SAMPLES_20MHZ_4US 80
#define SAMPLES_40MHZ_4US 160
#define SAMPLES_80MHZ_4US 320
/* New HW RSSI Mode support */
#ifdef WLPHY_HWRSSI
	#if defined(WLPHY_HWRSSI_DISABLED)
		#define PHY_HWRSSI_ENAB(rssiinfo)		(0)
	#else
		#define PHY_HWRSSI_ENAB(rssiinfo)  		(rssiinfo->hw_rssi_enable)
	#endif
#else
	#define PHY_HWRSSI_ENAB(rssiinfo)			(0)
#endif /* WLPHY_HWRSSI */

/* forward declaration */
typedef struct phy_ac_rssi_info phy_ac_rssi_info_t;

/* register/unregister ACPHY specific implementations to/from common */
phy_ac_rssi_info_t *phy_ac_rssi_register_impl(phy_info_t *pi,
	phy_ac_info_t *aci, phy_rssi_info_t *ri);
void phy_ac_rssi_unregister_impl(phy_ac_rssi_info_t *info);

/* ************************************************************************* */
/* ************************************************************************* */
/* ************************************************************************* */
/* ************************************************************************* */
void phy_ac_rssi_init_gain_err(phy_ac_rssi_info_t *info);
void phy_ac_hw_rssi_config(phy_ac_rssi_info_t *info);


#endif /* _phy_ac_rssi_h_ */
